// (MỚI) Chạy khi popup được tải xong
document.addEventListener('DOMContentLoaded', () => {
  const tokenInput = document.getElementById('authToken');
  const saveBtn = document.getElementById('saveTokenBtn');
  const saveStatus = document.getElementById('saveTokenStatus');

  // 1. Tải token đã lưu (nếu có)
  // Chúng ta dùng chrome.storage.local để lưu vĩnh viễn
  chrome.storage.local.get(['userToken'], (result) => {
    if (result.userToken) {
      tokenInput.value = result.userToken;
      saveStatus.textContent = 'Đã tải token đã lưu.';
      setTimeout(() => saveStatus.textContent = '', 2000);
    }
  });

  // 2. Thêm logic cho nút "Lưu"
  saveBtn.addEventListener('click', () => {
    const tokenToSave = tokenInput.value.trim();
    if (tokenToSave) {
      // Lưu token vào bộ nhớ vĩnh viễn của tiện ích
      chrome.storage.local.set({ userToken: tokenToSave }, () => {
        saveStatus.textContent = 'Đã lưu token!';
        setTimeout(() => saveStatus.textContent = '', 2000);
      });
    } else {
      // Nếu ô trống, ta sẽ xóa token
      chrome.storage.local.remove('userToken', () => {
         saveStatus.textContent = 'Đã xóa token!';
         setTimeout(() => saveStatus.textContent = '', 2000);
      });
    }
  });
});

// --- Logic cũ của bạn bắt đầu từ đây ---

// SỬA: Bọc hàm set cookie trong Promise để dùng async/await
function setCookiePromise(cookieDetails) {
  return new Promise((resolve, reject) => {
    chrome.cookies.set(cookieDetails, (cookie) => {
      if (cookie) {
        resolve(cookie);
      } else {
        // Nếu có lỗi, chrome.runtime.lastError sẽ chứa thông tin
        reject(new Error(chrome.runtime.lastError.message));
      }
    });
  });
}

// SỬA: Dùng hàm async để có thể 'await' từng bước
document.getElementById('setCookieBtn').addEventListener('click', async () => {
  const cookieValue = document.getElementById('cookieValue').value.trim();
  const statusEl = document.getElementById('status');
  const setCookieBtn = document.getElementById('setCookieBtn');

  // SỬA: Lấy token người dùng nhập vào
  const userToken = document.getElementById('authToken').value.trim();

  // --- (SỬA ĐỔI) LOGIC KIỂM TRA TOKEN ---
  // Xóa bỏ MASTER_TOKEN. Giờ chúng ta sẽ gọi API
  
  if (!userToken) {
    statusEl.textContent = 'Lỗi: Vui lòng nhập Token kích hoạt.';
    statusEl.style.color = 'red';
    return;
  }

  // Hiển thị trạng thái "Đang kiểm tra token"
  statusEl.textContent = 'Đang xác thực token...';
  statusEl.style.color = 'black';
  setCookieBtn.disabled = true;

  // (QUAN TRỌNG) THAY ĐỔI URL NÀY THÀNH ĐỊA CHỈ WEBSITE CỦA BẠN
  const API_CHECK_URL = "https://thueotp.net/api_check_token.php";

  try {
    const apiResponse = await fetch(API_CHECK_URL, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json'
        },
        body: JSON.stringify({ token: userToken })
    });

    if (!apiResponse.ok) {
        throw new Error(`Lỗi mạng hoặc máy chủ (HTTP ${apiResponse.status})`);
    }

    const result = await apiResponse.json();

    if (!result.success) {
        // Server báo token không hợp lệ
        throw new Error(result.message || 'Token không hợp lệ.');
    }
    
    // Nếu token hợp lệ, tiếp tục...
    statusEl.textContent = 'Token hợp lệ! Đang xử lý cookie...';

  } catch (error) {
    // Bất kỳ lỗi nào (mạng, token sai, v.v.)
    statusEl.textContent = `Lỗi xác thực: ${error.message}`;
    statusEl.style.color = 'red';
    setCookieBtn.disabled = false;
    return; // Dừng lại
  }
  // --- (KẾT THÚC SỬA ĐỔI) LOGIC KIỂM TRA TOKEN ---

  // --- Logic cookie (giữ nguyên từ file trước của bạn) ---

  if (!cookieValue) {
    statusEl.textContent = 'Lỗi: Vui lòng nhập giá trị cookie.';
    statusEl.style.color = 'red';
    setCookieBtn.disabled = false; // Kích hoạt lại nút nếu chỉ thiếu cookie
    return;
  }

  // Tách toàn bộ chuỗi cookie bằng dấu ;
  const cookiesToSet = cookieValue.split(';').filter(c => c.trim() !== '');
  
  if (cookiesToSet.length === 0) {
    statusEl.textContent = 'Lỗi: Không tìm thấy cookie nào hợp lệ.';
    statusEl.style.color = 'red';
    setCookieBtn.disabled = false;
    return;
  }

  statusEl.innerHTML = `Token hợp lệ! Tìm thấy <strong>${cookiesToSet.length}</strong> cookie. Bắt đầu tiêm...<br><hr>`;
  
  let successCount = 0;
  let errorMessages = [];

  for (const cookieString of cookiesToSet) {
    const parts = cookieString.split('=');
    const name = parts.shift().trim();
    const value = parts.join('=').trim();

    if (!name || !value) {
      statusEl.innerHTML += `Bỏ qua mục không hợp lệ: "${cookieString}"<br>`;
      continue;
    }

    statusEl.innerHTML += `Đang tiêm <strong>${name}</strong>... `;

    try {
      const cookieDetails = {
        url: "https://www.tiktok.com",
        domain: ".tiktok.com",
        name: name,
        value: value,
        path: "/",
        secure: true,
        httpOnly: false,
        sameSite: "no_restriction"
      };

      await setCookiePromise(cookieDetails);
      statusEl.innerHTML += `<span style="color: green;">Thành công!</span><br>`;
      successCount++;

    } catch (error) {
      statusEl.innerHTML += `<span style="color: red;">Thất bại!</span><br>`;
      errorMessages.push(`Lỗi cookie '${name}': ${error.message}`);
      console.error(`Lỗi khi đặt cookie '${name}':`, error.message);
    }
  }

  statusEl.innerHTML += `<hr>Hoàn tất: <strong>${successCount}</strong> thành công, <strong>${errorMessages.length}</strong> thất bại.<br>`;

  if (errorMessages.length > 0) {
    statusEl.innerHTML += `Lỗi đầu tiên: ${errorMessages[0]}<br>`;
  }

  if (successCount > 0) {
    statusEl.innerHTML += "Đang mở và tải lại tab TikTok...";
    
    chrome.tabs.create({ url: "https://www.tiktok.com", active: true }, (newTab) => {
      setTimeout(() => {
        chrome.tabs.reload(newTab.id);
      }, 1000); 
    });

  } else {
    statusEl.innerHTML += "Không có cookie nào được tiêm thành công.";
  }

  // Kích hoạt lại nút
  setCookieBtn.disabled = false;
});